#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

int uporedi(const void *a, const void *b) {
    ll x = *(ll*)a;
    ll y = *(ll*)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

int main() {
    int N;
    scanf("%d", &N);

    ll *razlike = (ll*)malloc(N * sizeof(ll));
    ll *zbirovi = (ll*)malloc(N * sizeof(ll));

    for (int i = 0; i < N; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        razlike[i] = x - y;
        zbirovi[i] = x + y;
    }

    qsort(razlike, N, sizeof(ll), uporedi);
    qsort(zbirovi, N, sizeof(ll), uporedi);

    ll odgovor = 0;

    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && razlike[j] == razlike[i]) j++;
        ll k = j - i;
        odgovor += k * (k - 1) / 2;
        i = j;
    }

    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && zbirovi[j] == zbirovi[i]) j++;
        ll k = j - i;
        odgovor += k * (k - 1) / 2;
        i = j;
    }

    printf("%lld\n", odgovor);

    free(razlike);
    free(zbirovi);
    return 0;
}